;===============================================================================
;
;	utilis par le compositeur GoMaestro (mixage audio + boites (x))
;
; (dernires modifs pour version 1.092: passage au systme zak)
;
;===============================================================================

sr = 44100
kr = 4410
ksmps = 10
nchnls = 2

zakinit 4998,1     ; le canal du signal affect (wet) est celui correspondant au numro de 
				   ; l'instrument correspondant
				   ; 1 et 2: canaux du signal source
				   ; ... voir comment a se passe dans instr 3

; lecture du fichier source
;---------------------------
;	p4 temps de dpart dans le fichier
;	p5 facteur d'amplitude
;	p6 dure de l'attaque (fade in)
;	p7 dure du decay (fade out)
;	p8 facteur d'extension/compression
;	p9 nom du fichier

         instr 1 ; -------------------------  utiliser si fichier mono
ilength  filelen p9
	     print ilength
kamp     linseg 0, p6, p5, ilength/p8-p6-p7, p5, p7, 0
asig     diskin p9, p8, p4*p8, 1
         zawm asig*kamp, 1
	     zawm asig*kamp, 2
         endin

             instr 2 ; ------------------------- stereo
ilength      filelen p9
	         print ilength
kamp         linseg 0, p6, p5, ilength/p8-p6-p7, p5, p7, 0
asig1, asig2 diskin p9, p8, p4*p8, 1
	         zawm asig1*kamp, 1
	         zawm asig2*kamp, 2
             endin



; instument 3:  "send effect" (mixer)           
;------------------------------------           
;	p4	numro d'instrument                     
;	p5 	dure d'attaque de l'effet		A
;	p6 	temps de dbut de l'effet		D     ;; en fait, on a toujours p6=p5
;	p7  proportion de wet en p6
;   p8	temps de fin				S
;	p9 	proportion de wet en p8		
;	p10 dure de descente (release)		R

          instr     3
kdryamt   linseg    1, p5, 1-p7, p8-p6, 1-p9, p10, 1
kwetamt   linseg    0, p5, p7, p8-p6, p9, p10, 0

awetsig1  zarg 1, kwetamt               
awetsig2  zarg 2, kwetamt               
          zaw awetsig1+awetsig2, p4    
	      zkw kdryamt	
          endin


; instrument 4999: player
;------------------------

          instr   4999
asig1     zar 1
asig2     zar 2
kdryamt   zkr 1
kdryamt   =  (kdryamt == 0) ? 1 : kdryamt
          zkcl    1, 1
          zacl    1, 2
		  outs    asig1*kdryamt, asig2*kdryamt
          endin


;********************************************************************************
;	banque d'effets
;********************************************************************************

;--------------------------------------------------------
; l'effet qui ne fait rien (ou presque)
;--------------------------------------

	  instr 100
asig  zar   100
      outs  0.5*asig,0.5*asig
	  endin



;--------------------------------------------------------
; reverb de base
;---------------

	 instr	99
asig zar    99
asig reverb	asig, p4
	 outs	0.5*asig, 0.5*asig
	 endin



;--------------------------------------------------------
; Eric Lyon's strange reverb 
;----------------------------

          instr     2316
asig      zar       2316
iorig     =         .05
irev      =         1.-iorig
igain     =         1.0
ilpgain   =         1.5
icgain    =         .1
ialpgain  =         0.1
ispeed1   =         p4
ispeed2   =         p5
ispeed3   =         p6
ispeed4   =         p7
icf1      =         p8
icf2      =         p9
icf3      =         p10
icf4      =         p11
ifac      =         2
ibw1      =         icf1/ifac
ibw2      =         icf2/ifac
ibw3      =         icf3/ifac
ibw4      =         icf4/ifac
; CYCLIC AMPLITUDE ENVELOPES
aenv1     oscil     igain, ispeed1, 1
aenv2     oscil     igain, ispeed2, 2
aenv3     oscil     igain, ispeed3, 3
aenv4     oscil     igain, ispeed4, 4
; BREAK INTO BANDS
ares1     reson     asig, icf1, ibw1, 1
ares2     reson     asig, icf2, ibw2, 1
ares3     reson     asig, icf3, ibw3, 1
ares4     reson     asig, icf4, ibw4, 1
; SUM THE ENVELOPED BANDS
asum      =         (ares1*aenv1)+(ares2*aenv2)+(ares3*aenv3)+(ares4*aenv4)
; LOWPASS AND COMB SEQUENCE
alp       tone      asum, 1000
adright   delay     alp, .178
adleft    delay     alp, .215
asumr     =         asum+(adright*ilpgain)
asuml     =         asum+(adleft*ilpgain)
acr1      comb      asumr, 2, .063
acr2      comb      acr1+asumr,. 5, .026
acl1      comb      asuml, 2, .059
acl2      comb      acl1+asuml, .5, .031
acsumr    =         asumr+(acr2*icgain)
acsuml    =         asuml+(acl2*icgain)
; ALLPASS COMB SEQUENCE
alpo      alpass    asum, 3, 085
alpol     comb      alpo, 2.8, .526
alpor     comb      alpo, 2.8, .746
alol      tone      alpol, 500
alor      tone      alpor, 500
alold     delay     alol, .095
alord     delay     alor, .11
; SUM REVERBERATION COMPONENTS
arevl     =         (alpol*ialpgain)+acsuml+alold
arevr     =         (alpor*ialpgain)+acsumr+alord
aorig     =         asig*iorig
; MIX BACK ORIGINAL SIGNAL
          outs      (arevl*irev)+aorig,(arevr*irev)+aorig
          endin



;--------------------------------------------------------
; Eric Lyon's metallic reverb 
;----------------------------

          instr     2315
ilp1      =         1/p4            ; p4p9 ARE RESONANCE FREQUENCIES
ilp2      =         1/p5
ilp3      =         1/p6
ilp4      =         1/p7
ilp5      =         1/p8
ilp6      =         1/p9
irvt      =         p10
asig      zar       2315
aecho1    comb      asig, irvt, ilp1, 0 
aecho2    comb      asig, irvt, ilp2, 0
aecho1    =         asig+aecho1
aecho2    =         asig+aecho2
aecho3    comb      aecho1, irvt, ilp3, 0
aecho4    comb      aecho1, irvt, ilp4, 0
aecho5    comb      aecho2, irvt, ilp5, 0
aecho6    comb      aecho2, irvt, ilp6, 0
aout1     =         (aecho1+aecho3+aecho5)*.1
aout2     =         (aecho2+aecho4+aecho6)*.1
          outs      aout1, aout2
          endin



;--------------------------------------------------------
; Sean Costello's FDN reverb
;---------------------------

; 8 delay line FDN reverb, with feedback matrix based upon 
; physical modeling scattering junction of 8 lossless waveguides
; of equal characteristic impedance. Based on Julius O. Smith III, 
; "A New Approach to Digital Reverberation using Closed Waveguide
; Networks," Proceedings of the International Computer Music 
; Conference 1985, p. 47-53 (also available as a seperate
; publication from CCRMA), as well as some more recent papers by
; Smith and others.
;
; Coded by Sean Costello, October 1999

instr 199        
        
; Note: asig is the global input to the reverb.

afilt1 init 0
afilt2 init 0
afilt3 init 0
afilt4 init 0
afilt5 init 0
afilt6 init 0
afilt7 init 0
afilt8 init 0

; Delay times chosen to be prime numbers.
; Works with sr=44100 ONLY. If you wish to
; use a different delay time, find some new
; prime numbers that will give roughly the
; same delay times for the new sampling rate. 
; Or adjust to taste.
idel1 = (2473.000/sr)
idel2 = (2767.000/sr)
idel3 = (3217.000/sr)
idel4 = (3557.000/sr)
idel5 = (3907.000/sr)
idel6 = (4127.000/sr)
idel7 = (2143.000/sr)
idel8 = (1933.000/sr)


igain = p4      ; gain of reverb. Adjust empirically
                ; for desired reverb time. .6 gives
                ; a good small "live" room sound, .8
                ; a small hall, .9 a large hall,
                ; .99 an enormous stone cavern.

ipitchmod = p5  ; amount of random pitch modulation
                ; for the delay lines. 1 is the "normal"
                ; amount, but this may be too high for
                ; held pitches such as piano tones.
                ; Adjust to taste.

itone = p6      ; Cutoff frequency of lowpass filters
                ; in feedback loops of delay lines,
                ; in Hz. Lower cutoff frequencies results
                ; in a sound with more high-frequency
                ; damping.

; k1-k8 are used to add random pitch modulation to the
; delay lines. Helps eliminate metallic overtones
; in the reverb sound.
k1      randi   .001, 3.1, .06
k2      randi   .0011, 3.5, .9
k3      randi   .0017, 1.11, .7
k4      randi   .0006, 3.973, .3
k5      randi   .001, 2.341, .63
k6      randi   .0011, 1.897, .7
k7      randi   .0017, 0.891, .9
k8      randi   .0006, 3.221, .44

; apj is used to calculate "resultant junction pressure" for 
; the scattering junction of 8 lossless waveguides
; of equal characteristic impedance. If you wish to
; add more delay lines, simply add them to the following 
; equation, and replace the .25 by 2/N, where N is the 
; number of delay lines.
apj = .25 * (afilt1 + afilt2 + afilt3 + afilt4 + afilt5 + afilt6 + afilt7 + afilt8)

asig    zar     199

adum1   delayr  1
adel1   deltapi idel1 + k1 * ipitchmod
        delayw  asig + apj - afilt1

adum2   delayr  1
adel2   deltapi idel2 + k2 * ipitchmod
        delayw  asig + apj - afilt2

adum3   delayr  1
adel3   deltapi idel3 + k3 * ipitchmod
        delayw  asig + apj - afilt3

adum4   delayr  1
adel4   deltapi idel4 + k4 * ipitchmod
        delayw  asig + apj - afilt4

adum5   delayr  1
adel5   deltapi idel5 + k5 * ipitchmod
        delayw  asig + apj - afilt5

adum6   delayr  1
adel6   deltapi idel6 + k6 * ipitchmod
        delayw  asig + apj - afilt6

adum7   delayr  1
adel7   deltapi idel7 + k7 * ipitchmod
        delayw  asig + apj - afilt7

adum8   delayr  1
adel8   deltapi idel8 + k8 * ipitchmod
        delayw  asig + apj - afilt8

; 1st order lowpass filters in feedback
; loops of delay lines.
afilt1  tone    adel1 * igain, itone
afilt2  tone    adel2 * igain, itone
afilt3  tone    adel3 * igain, itone
afilt4  tone    adel4 * igain, itone
afilt5  tone    adel5 * igain, itone
afilt6  tone    adel6 * igain, itone
afilt7  tone    adel7 * igain, itone
afilt8  tone    adel8 * igain, itone

; The outputs of the delay lines are summed
; and sent to the stereo outputs. This could
; easily be modified for a 4 or 8-channel 
; sound system.
aout1 = (afilt1 + afilt3 + afilt5 + afilt7)
aout2 = (afilt2 + afilt4 + afilt6 + afilt8)
outs    aout1, aout2

endin


;--------------------------------------------------------
; Richard Boulanger's SWIRL reverb
; (got it from Trapped In Convert)
;---------------------------------

       instr   299                            ; p4 = panrate
k1     oscil   .5, p4, 10
k2     =       .5 + k1
k3     =       1 - k2
asig   zar     299
asig   reverb  asig, 2.1
       outs    asig * k2, (asig * k3) * (-1)
       endin


;---------------------------------------------------------------------------
; Hans Mikelson's Wah-Wah
;---------------------------------------------------------------------------
         instr   3016
irate    =      p4                  ; AUTO WAH RATE
idepth   =      p5                  ; LOW PASS DEPTH
ilow     =      p6                  ; MINIMUM FREQUENCY
ifmix    =      p7/1000             ; FORMANT MIX
itab1    =      p8                  ; WAVE FORM TABLE
kosc1    oscil  .5, irate, itab1, .25        ; OSCILATOR
kosc2    =      kosc1 + .5          ; RESCALE FOR 0-1
kosc3    =      kosc2               ; FORMANT DEPTH 0-1
klopass  =      idepth*kosc2+ilow   ; LOW PASS FILTER RANGE
kform1   =      430*kosc2 + 300     ; FORMANT 1 RANGE
kamp1    =      ampdb(-2*kosc3 + 59)*ifmix   ; FORMANT 1 LEVEL
kform2   =      220*kosc2 + 870     ; FORMANT 2 RANGE
kamp2    =      ampdb(-14*kosc3 + 55)*ifmix  ; FORMANT 2 LEVEL
kform3   =      200*kosc2 + 2240    ; FORMANT 3 RANGE
kamp3    =      ampdb(-15*kosc3 + 32)*ifmix  ; FORMANT 3 LEVEL
asig     zar    3016                ; READ INPUT CHANNEL
afilt    butterlp asig, klopass     ; LOW PASS FILTER
ares1    reson  afilt, kform1, kform1/8     ; COMPUTE SOME FORMANTS
ares2    reson  afilt, kform2, kform1/8     ; TO ADD CHARACTER TO THE
ares3    reson  afilt, kform3, kform1/8     ; SOUND
aresbal1 balance ares1, afilt       ; ADJUST FORMANT LEVELS
aresbal2 balance  ares2, afilt
aresbal3 balance  ares3, afilt
asig     =      afilt+kamp1*aresbal1+kamp2*aresbal2+kamp3*aresbal3
	     outs	0.5*asig, 0.5*asig
         endin

;---------------------------------------------------------------------------
; Hans Mikelson's TUBE DISTORTION
;---------------------------------------------------------------------------
        instr   3013
igaini  =       p4                  ; PRE GAIN
igainf  =       p5                  ; POST GAIN
iduty   =       p6                  ; DUTY CYCLE OFFSET
islope  =       p7                  ; SLOPE OFFSET
itable  =       p8                  ; Distortion table (6 ou 7)
asign   init    0                   ; DELAYED SIGNAL
kamp    linseg  0, .002, 1, p3-.004, 1, .002, 0   ; DECLICK
asig    zar     3013                ; READ INPUT CHANNEL
aold    =       asign               ; SAVE THE LAST SIGNAL
asign   =       igaini*asig/60000   ; NORMALIZE THE SIGNAL
aclip   tablei  asign,itable,1,.5        ; READ THE WAVESHAPING TABLE
aclip   =       igainf*aclip*15000  ; RE-AMPLIFY THE SIGNAL
atemp   delayr  .1                  ; AMPLITUDE AND SLOPE BASED DELAY
aout    deltapi (2-iduty*asign)/1500 + islope*(asign-aold)/300
        delayw  aclip
        outs    0.5*aout, 0.5*aout
        endin
