; orchestra by Hans Mikelson

sr = 44100
kr = 44100
ksmps = 1
nchnls = 2

;---------------------------------------------------------------------------
; The Birds
;---------------------------------------------------------------------------
       instr 1

idur   =      p3
iamp   =      p4+100
ifqc   =      cpspch(p5)
ipanl     =           sqrt(p6)
ipanr	 =	 sqrt(1-p6)
iwrbfm =      p7
iwrbrt =      p8
iwrbam =      p9
iwave  =      p10

iwbeg  =      (iwrbfm>0 ? 1+iwrbfm     : 1/(1-iwrbfm)) ; Determine whether to
iwend  =      (iwrbfm>0 ? 1/(1+iwrbfm) : 1-iwrbfm)     ; ramp up or down.

kamp   linseg 0, .01, iamp, idur-.02, iamp, .01, 0   ; Declick

; Frequency Modulation
krate  linseg iwbeg, idur, iwend
kfmod  oscil  iwrbam*krate, iwrbrt*krate, 1
kfmod  =      1+kfmod
kfqc   =      kfmod*ifqc

asig   oscil  kamp*kfmod, kfqc, iwave
aout	pareq	asig, 6000, .707, iamp/2000, 2

       outs   aout*ipanl-aout*ipanr*(1-100/iamp), aout*ipanr-aout*ipanl*(1-100/iamp)

       endin
