@echo off

rem This batch file is intended to automate the building of the compiled-lisp
rem for use on your NTEmacs installation.
rem
rem Usage is simple : 'compile' or 'compile /e emacs_dir' depending upon whether
rem the system-global environment-variable EMACS_DIR is set or not (the latter form
rem if not - replace 'emacs-dir' with the path to your emacs root installation).

if "%1" == "/e" set EMACS_DIR=%2
if "%EMACS_DIR%" == "" goto noenv
if not exist "%EMACS_DIR%\bin\emacs.exe" goto noemacs

:doit
echo Clearing existing compiled-lisp...
echo y | erase *.elc
echo Recompiling lisp...
"%emacs_dir%\bin\emacs.exe" -q -nw -batch -l calc-maint.el -f calc-compile
if errorlevel 1 goto failed
echo Done!
goto endex

:failed
goto endex

:noemacs
echo "%EMACS_DIR%\bin\emacs.exe" was not found!
goto endex

:noenv
echo Environment var EMACS_DIR not set!
echo You may specify this on the command like with the /e switch, e.g.
echo ... compile.bat /e emacs_dir
echo Please try again.
goto endex

:endex
